var samplePageObj = {
  // 샘플 타이틀
  title: '렌더링 방식',
  subtitle: '보다 빨라진 렌더링 방법을 소개합니다.',
  // 샘플 설명
  desc: '전통적인 LazyLoad방식 과 IB Sheet 8에서 추가된 FastLoad 방식에 따른 화면 렌더링 비교 예제입니다.<br>조회 후 세로 스크롤을 움직이면서 차이를 확인해 보세요.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 2,
      Alternate: 2
    },
    LeftCols: [
      {
        Header: 'No',
        Name: 'SEQ',
        Width: '90'
      }
    ],
    Cols: [
      {
        Header: '확인',
        Type: 'Bool',
        Name: 'sCheck',
        Width: '60'
      },
      {
        Header: '회사',
        Type: 'Text',
        Name: 'sCompany',
        Width: '150'
      },
      {
        Header: '판매 국가',
        Type: 'Text',
        Name: 'sCountry',
        Width: '100'
      },
      {
        Header: '판매 수량',
        Type: 'Int',
        Name: 'sSaleQuantity',
        Width: '100'
      },
      {
        Header: '판매 증가량',
        Type: 'Int',
        Name: 'sSaleIncrease',
        Width: '100'
      },
      {
        Header: '가격',
        Type: 'Int',
        Name: 'sPrice',
        Format: '#,### \\원',
        Width: '180'
      },
      {
        Header: '만족도',
        Type: 'Int',
        Name: 'sSatisfaction',
        Format: '# \\%',
        Width: '70'
      },
      {
        Header: '코멘트',
        Type: 'Text',
        Name: 'sComment',
        Width: '150',
        RelWidth: 1
      },
    ],
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button onclick=\'sampleBtn(this, 2)\' class=\'mgr10\'>스크롤조회(LazyLoad)</button>'
    + '<button onclick=\'sampleBtn(this, 0)\' class=\'mgr10\'>대용량조회(FastLoad)</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
    sheet.dispose(); //  시트 삭제
    // SearchMode =   0:FastLoad , 2:LazyLoad
    samplePageObj.init.Cfg = {
      SearchMode: arguments[1],
      Alternate: 2
    };
    samplePageObj.create(); // 시트 생성
    sheet.loadSearchData(samplePageObj.externalFunction.createData(1000)); // 데이타 생성 및 로딩
  },
  externalFunction: {
    createData: function (count) {
      var data = [];
      var company = [
        'Google',
        'Apple',
        '삼성전자',
        'LG전자',
        '한화',
        'Microsoft',
        '현대',
        '현기차',
        'SK',
        '롯데'
      ];
      var country = [
        '미국',
        '일본',
        '한국',
        '영국',
        '캐나다',
        '중국',
        '프랑스',
        '브라질',
        '인도',
        '이탈리아'
      ];

      for (var i = 0; i < count; i++) {
        data.push({
          sCompany: company[Math.floor(Math.random() * 10)],
          sCountry: country[Math.floor(Math.random() * 10)],
          sSaleQuantity: Math.floor(Math.random() * 100000),
          sSaleIncrease: Math.floor(Math.random() * 10000),
          sPrice: Math.floor(Math.random() * 10000000),
          sSatisfaction: Math.floor(Math.random() * (100 - 50 + 1) + 50),
        });
      }
      // Not used by jsfiddle.
      // 데이터 구문 처리
      var showData = [];

      for (var i = 0; i < data.length && i < 20; i++) {
        showData.push(data[i]);
      }
      try {
        var _data = JSON.stringify(showData, null, 2);

        samplePageObj.data = _data;
        if (data.length > 20) { _data = _data.substring(0, _data.length - 1) + '...\n]'; }
        myTabs.contents.items(1).setContents('<pre><code class=\'language-json\'>' + _data + '</code></pre>');
        hljs.initHighlighting.called = false;
        hljs.initHighlighting();
      } catch (e) {
        console.log(e.message);
      }
      // Not used by jsfiddle.

      return data;
    }
  },

  // event구문
  event: {
  },

  // data
  data: '해당 화면에서는 데이터가 동적으로 생성됩니다.'
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
